import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../util/processResponse";

const initialState = {
    isVisibleRecaptcha: false,
    loading: false,
};

export const getReCaptcha = createAsyncThunk("getReCaptcha", async () => {
    const URL = `${BASE_API_URL_STG}/user/addon-activity?name=Recaptcha`;
    const response = await queryResponse(URL);
    return response;
});

const getReCaptchaVisibility = createSlice({
    name: "reCaptcha",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getReCaptcha.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getReCaptcha.fulfilled, (state, { payload }) => {
            const { status, records } = payload || {};
            if (status?.code === 200) {
                state.isVisibleRecaptcha = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(getReCaptcha.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default getReCaptchaVisibility.reducer;
